<?php

namespace App\Http\Controllers;

use nusoap_client;
use App\User;
use App\Empresa;
use App\UsuarioEmpresa;
use Auth;
use Hash;
use Validator;
use Illuminate\Http\Request;

class UsuarioController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    public function listar() {
        $user_id = Auth::user()->id;
        $usuarios = User::where('user_id', '=', $user_id)->get();
        return view('lista_usuario', compact('usuarios'));
    }

    public function novo() {
        $id = Auth::user()->id;
        $empresas = Empresa::where('user_id', '=', $id)->get();
        return view('cad_usuario', compact('empresas'));
    }

    public function trocar_senha() {
        return view('trocar_senha');
    }

    public function atualizar_senha(Request $request) {
        $validator = Validator::make(
                        [
                    "senha_atual" => $request->input("senha_atual"),
                    "nova_senha" => $request->input("nova_senha"),
                    "confirmacao_senha" => $request->input("confirmacao_senha")
                        ], [
                    "senha_atual" => "required|min:6",
                    "nova_senha" => "required|min:6",
                    "confirmacao_senha" => "required|min:6"
                        ]
        );

        if ($validator->fails()) {
            return redirect()->action("UsuarioController@trocar_senha")->withInput()->withErrors($validator);
        }

        if ($request->input("nova_senha") == $request->input("confirmacao_senha")) {
            $user_id = Auth::user()->id;
            $usuario = User::find($user_id);
            if (Hash::check($request->input("senha_atual"), $usuario->password)) {
                $usuario->password = Hash::make($request->input("nova_senha"));
                $usuario->save();
                return view('trocar_senha');
            }
            return redirect()->action("UsuarioController@trocar_senha")->withInput()->with('mensagem', "Senha atual inválida.");
        } else {
            return redirect()->action("UsuarioController@trocar_senha")->withInput()->with('mensagem', "Nova senha diferente da senha de confirmação.");
        }
    }

    public function editar($id) {
        $usuario = User::find($id);

        $user_id = Auth::user()->id;
        $empresas = Empresa::where('user_id', '=', $user_id)->get();
        return view('cad_usuario', compact(['usuario', 'empresas']));
    }

    public function incluir(Request $request) {

        $validator = Validator::make(
                        [
                    "nome" => $request->input("nome_usuario"),
                    "email" => $request->input("email"),
                    "senha" => $request->input("senha")
                        ], [
                    "nome" => "required:255",
                    "email" => "required:255",
                    "senha" => "required|min:6"
                        ]
        );

        if ($validator->fails()) {
            return redirect()->action("UsuarioController@novo")->withInput()->withErrors($validator);
        }

        $user_id = Auth::user()->id;

        $user = User::where('user_id', '=', $user_id)->where('email', '=', $request->input("email"))->first();
        if (count($user) == 0) {
            $usuario = new User();
            $usuario->user_id = $user_id;
            $usuario->name = $request->input("nome_usuario");
            $usuario->email = $request->input("email");
            $usuario->password = Hash::make($request->input("senha"));
            $usuario->status = 1;
            $usuario->tipo = 1;
            $usuario->save();

            if ($request->input('idempresa') != null) {
                foreach ($request->input('idempresa') as $key => $v) {
                    $usuarioEmpresa = new UsuarioEmpresa();
                    $usuarioEmpresa->empresa_id = $v;
                    $usuarioEmpresa->user_id = $usuario->id;
                    $usuarioEmpresa->save();
                }
            }
        }
        return redirect('usuario/listar');
    }

    public function atualizar(Request $request, $id) {
        $validator = Validator::make(
                        [
                    "nome" => $request->input("nome_usuario"),
                    "email" => $request->input("email")
                        ], [
                    "nome" => "required:255",
                    "email" => "required:255"
                        ]
        );

        if ($validator->fails()) {
            return redirect()->action("UsuarioController@editar", array('id' => $id))->withInput()->withErrors($validator);
        }

        $user_id = Auth::user()->id;
        $user = User::where('id', '<>', $id)->where('user_id', '=', $user_id)->where('email', '=', $request->input("email"))->first();
        if (count($user) == 0) {
            $usuario = User::find($id);
            $usuario->user_id = $user_id;
            $usuario->name = $request->input("nome_usuario");
            $usuario->email = $request->input("email");

            if ($request->input("senha") != "") {
                $usuario->password = Hash::make($request->input("senha"));
            }

            $usuario->status = (($request->input("status")) ? 1 : 0);
            $usuario->save();

            $usuario->usuario_empresa()->delete();
            if ($request->input('idempresa') != null) {
                foreach ($request->input('idempresa') as $key => $v) {
                    $usuarioEmpresa = new UsuarioEmpresa();
                    $usuarioEmpresa->empresa_id = $v;
                    $usuarioEmpresa->user_id = $usuario->id;
                    $usuarioEmpresa->save();
                }
            }
        }
        return redirect('usuario/listar');
    }

    public function excluir($id) {
        try {
            User::destroy($id);
            return redirect('usuario/listar');
        } catch (\PDOException $ex) {
            $mensagem = "";
            if ($ex->getCode() == 23000) {//caso possuir referencia em com outras tabelas
                $mensagem = "Não e possivel realizar a exclusão do registro pois existe relação com outros modulos.";
            } else {
                $mensagem = "Erro!";
            }
            return redirect('usuario/listar')->with('mensagem', $mensagem);
        }
    }

}
