<?php
namespace Eduardokum\LaravelBoleto\Boleto\Banco;

use Eduardokum\LaravelBoleto\Boleto\AbstractBoleto;
use Eduardokum\LaravelBoleto\Contracts\Boleto\Boleto as BoletoContract;
use Eduardokum\LaravelBoleto\Util;

class Bancoob extends AbstractBoleto implements BoletoContract
{
    const BANCOBB_CONST_NOSSO_NUMERO = "3197";
    
    const PARCELA = "1";
    
    /**
     * Código do banco
     * @var string
     */
    protected $codigoBanco = self::COD_BANCO_BANCOOB;
    /**
     * Define as carteiras disponíveis para este banco
     * @var array
     */
    protected $carteiras = array('1','3', '5');
    /**
     * Espécie do documento, coódigo para remessa
     * @var string
     */
    protected $especiesCodigo = [
        'DM' => '01',
        'NP' => '02',
        'DS' => '12',
    ];
    /**
     * Define o número do convênio (4, 6 ou 7 caracteres)
     *
     * @var string
     */
    protected $convenio;
    /**
     * Define o número do convênio. Sempre use string pois a quantidade de caracteres é validada.
     *
     * @param  string $convenio
     * @return Bancoob
     */
    
    
    protected $digitoVerificador;
    
    
    public function setConvenio($convenio)
    {
        $this->convenio = $convenio;
        return $this;
    }
    /**
     * Retorna o número do convênio
     *
     * @return string
     */
    public function getConvenio()
    {
        return $this->convenio;
    }

    /**
     * Define o número do convênio (4, 6 ou 7 caracteres)
     *
     * @var string
     */
    protected $parcela = self::PARCELA;
    /**
     * Define o número da parcela
     *
     * @param  string $parcela
     * @return Bancoob
     */
    public function setParcela($parcela)
    {
        $this->parcela = $parcela;
        return $this;
    }
    /**
     * Retorna o número da parcela
     *
     * @return string
     */
    public function getDigitoVerificador()
    {
        return $this->digitoVerificador;
    }

    public function setDigitoVerificador($digitoVerificador)
    {
        $this->digitoVerificador = $digitoVerificador;
        return $this;
    }
    /**
     * Retorna o número da parcela
     *
     * @return string
     */
    public function getParcela()
    {
        return $this->parcela;
    }
    
    /**
     * Método que valida se o banco tem todos os campos obrigadotorios preenchidos
     */
    public function isValid()
    {
        if ($this->numeroDocumento == ''
            || $this->agencia == ''
            || $this->conta == ''
            || $this->convenio == ''
            || $this->carteira == ''
        ) {
            return false;
        }

        return true;
    }
    /**
     * Gera o Nosso Número.
     *
     * @throws \Exception
     * @return string
     */
    protected function gerarNossoNumero()
    {
        $agencia = $this->getAgencia();
        $conta = $this->getConta().$this->getContaDv();
        $numero_boleto = $this->getNumero();

        $numero = Util::numberFormatGeral($agencia, 4).Util::numberFormatGeral($conta, 10).Util::numberFormatGeral($numero_boleto, 7);

        return $numero;
    }
    /**
     * Método que retorna o nosso numero usado no boleto. alguns bancos possuem algumas diferenças.
     *
     * @return string
     */
    public function getNossoNumeroBoleto()
    {
        $numero = $this->getNossoNumero();

        $constante = str_repeat(self::BANCOBB_CONST_NOSSO_NUMERO, 6);
        $soma = 0;

        for ($i=0; $i < strlen($numero); $i++) {
            if ((int)$numero[$i] > 0) {
                $soma += ((int)$numero[$i] * (int)$constante[$i]);
            }
        }

        $resto = $soma % 11;
        $digito_verificador = 0;

        if (($resto != 0) && ($resto != 1)){
            $digito_verificador = 11 - $resto;
        }

        //$nosso_numero = $this->getNumero().'-'.$digito_verificador;
        $nosso_numero = $this->getNumero().'-'.$this->getDigitoVerificador();

        return $nosso_numero;
    }
    /**
     * Método para gerar o código da posição de 20 a 44
     *
     * @return string
     * @throws \Exception
     */
    protected function getCampoLivre()
    {
        if ($this->campoLivre) {
            return $this->campoLivre;
        }

        $nossoNumero = $this->getNossoNumeroBoleto();

        //$this->getCarteira()
        $campoLivre = Util::numberFormatGeral(1, 1);
        $campoLivre .= Util::numberFormatGeral($this->getAgencia(), 4);
        $campoLivre .= Util::numberFormatGeral($this->getCarteira(), 2);
        $campoLivre .= Util::numberFormatGeral($this->getConvenio(), 7);
        $campoLivre .= Util::numberFormatGeral($nossoNumero, 8);
        $campoLivre .= Util::numberFormatGeral($this->getParcela(), 3); //Numero da parcela - Não implementado
        
        return $this->campoLivre = $campoLivre;
    }
}