<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-sm-12">
        <ol class="breadcrumb">
            <li><a href="<?php echo e(url('')); ?>"><i class="fa fa-home"></i></span>&nbsp;Início</a></li>
            <li><a href="<?php echo e(url('/empresa/listar')); ?>">Empresas</a></li>
            <li class="active">Empresa</li>
        </ol>
    </div>
    <div class="col-sm-12">
        <h4 class="page-title"><?php echo (isset($empresa)) ? 'Editar' : 'Cadastro de'; ?> Empresa</h4>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card-box">
            <div class="row">
                <div class="col-lg-12">
                    <?php if(count($errors) > 0): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                            <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                        </ul>
                    </div>
                    <?php endif; ?>

                    <form accept-charset="UTF-8"  class="form-horizontal" role="form" method="POST" action="<?php echo (!isset($empresa)) ? url("empresa/incluir") : url("empresa/" . $empresa->id . "/atualizar"); ?>">
                        <?php if (isset($empresa)) { ?>
                            <input type="hidden" name="_method" value="PUT" />
                        <?php } ?>
                        <?php echo e(csrf_field()); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">Nome</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-8">
                                        <input type="text" name="nome" class="form-control" value="<?php if(count($errors) > 0): ?><?php echo e(old("nome")); ?><?php else: ?><?php echo e(isset($empresa->nome) ? $empresa->nome : ''); ?><?php endif; ?>" placeholder="Digite nome da empresa" maxlength="255"/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">CNPJ</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-8">
                                        <input type="text" name="cnpj" class="form-control" value="<?php if(count($errors) > 0): ?><?php echo e(old("cnpj")); ?><?php else: ?><?php echo e(isset($empresa->cnpj) ? $empresa->cnpj : ''); ?><?php endif; ?>" placeholder="Digite seu CNPJ" maxlength="14" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">&nbsp;</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-8">
                                        <?php if (isset($empresa)) { ?>
                                            <div class="checkbox checkbox-primary">
                                                <input id="status" name="status" type="checkbox" <?php echo isset($empresa->status) && ($empresa->status == 1) ? 'checked' : ''; ?>>
                                                <label for="status">
                                                    Ativo
                                                </label>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">&nbsp;</div>
                        </div>
                        <div class="row">
                            <?php if (isset($empresa)) { ?>
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label class="">Razão Social</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <input type="text" name="razao_social" class="form-control" value="<?php echo e(isset($empresa->razao_social) ? $empresa->razao_social : ''); ?>" placeholder="" disabled="" />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label class="">IE</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <input type="text" name="ie" class="form-control" value="<?php echo e(isset($empresa->ie) ? $empresa->ie : ''); ?>" placeholder="" disabled="" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">&nbsp;</div>
                            </div>
                            <div class="row">
                                <div class="col-xs-12">
                                    <label>Endereço</label>
                                    <hr/>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <label for="cep">CEP</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-8">
                                            <input type="text" maxlength="9" id="cep" name="cep" value="<?php echo e(isset($empresa->cep) ? $empresa->cep : ''); ?>" class="form-control" disabled=""/>
                                        </div>
                                    </div>
                                </div>                 
                                <div class="col-sm-4">
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <label for="endereco">Endereço</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <input type="text" id="endereco" name="endereco" value="<?php echo e(isset($empresa->endereco) ? $empresa->endereco : ''); ?>" class="form-control" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <label for="numero">Número</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-8">
                                            <input type="text" id="numero" name="numero" value="<?php echo e(isset($empresa->numero) ? $empresa->numero : ''); ?>" class="form-control" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <label for="bairro">Bairro</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <input type="text" id="bairro" name="bairro" value="<?php echo e(isset($empresa->bairro) ? $empresa->bairro : ''); ?>" class="form-control" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <label for="uf">UF</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-8">
                                            <input type="text" id="uf" name="if" value="<?php echo e(isset($empresa->uf) ? $empresa->uf : ''); ?>" class="form-control" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <label for="cidade">Cidade</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <input type="text" id="cidade" name="cidade" value="<?php echo e(isset($empresa->cidade) ? $empresa->cidade : ''); ?>" class="form-control" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <label for="complemento">Complemento</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <input type="text" id="complemento" name="complemento" value="<?php echo e(isset($empresa->complemento) ? $empresa->complemento : ''); ?>" class="form-control" disabled="">
                                        </div>
                                    </div>
                                </div> 
                            <?php } ?>


                        </div>
                        <br/>
                        <?php if (!isset($empresa) || (isset($empresa) && $empresa->sincronizado == 0)) { ?>
                        <div class="row text-right">
                            <div class="col-lg-12 ">
                                <button type="submit" class="btn btn-success waves-effect waves-light m-l-10 btn-md">Salvar</button>
                            </div>
                        </div>
                        <?php }?>
                    </form>
                </div><!-- end col -->


            </div><!-- end row -->
        </div>
    </div><!-- end col -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>