@extends('layouts.app')

@section('content')
<!-- Page-Title -->
<div class="row">
    <div class="col-sm-12">
        <ol class="breadcrumb">
            <li><a href="{{url('')}}"><span class="m-l-5"><i class="fa fa-home"></i></span>&nbsp;Início</a></li>
            <li class="active">Empresas</li>
        </ol>
    </div>
    <div class="col-sm-12">
        <div class="btn-group pull-right m-t-15">
            <a href="{{url('/empresa/novo')}}" class="btn btn-primary waves-effect waves-light">Novo<span class="m-l-5"><i class="fa fa-plus"></i></span></a>
        </div>
        <h4 class="page-title">Empresas</h4>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        @if(session('mensagem'))
        <div class="alert alert-danger">
            <strong>Erro!</strong>
            {{ session('mensagem') }}
            </div>
        @endif
        <div class="card-box table-responsive">
            <table id="datatable-normal" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width="30%">Nome</th>
                        <th>CNPJ</th>
                        <th>Token</th>
                        <th width="10%">Status</th>
                        <th width="10%">Ações</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($empresas as $o)
                    <tr>
                        <td>{{$o->nome or ''}}</td>
                        <td>{{$o->cnpj or ''}}</td>
                        <td>{{$o->token or ''}}</td>
                        <td>@if ($o->status) Ativo @else Inativo @endif</td>
                        <td>
                            <a href="{{url('/empresa/'.$o->id.'/editar')}}" class="on-default edit-row"><i class="fa fa-pencil"></i></a>
                            <a href="javascript:void(0)" url="{{url('/empresa/'.$o->id.'/excluir')}}" class="on-default remove-row btn-remove"><i class="fa fa-trash-o"></i></a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->
@endsection
