<?php

if (!function_exists('mostra_data')) {

    function mostra_data($data) {
        if (!empty($data)) {
            $dt = explode('-', $data);
            $novaData = $dt[2] . '/' . $dt[1] . '/' . $dt[0];
            return $novaData;
        }
    }

}


if (!function_exists('mostra_data')) {

    function mostra_data($data) {
        if (!empty($data)) {
            $dt = explode('-', $data);
            $novaData = $dt[2] . '/' . $dt[1] . '/' . $dt[0];
            return $novaData;
        }
    }

}


if (!function_exists('mostra_data_hora')) {

    function mostra_data_hora($data) {
        if (!empty($data)) {
            $novaData = substr($data, 8, 2) . '/' . substr($data, 5, 2) . '/' . substr($data, 0, 4) . substr($data, 10, strlen($data) - 1);
            return $novaData;
        }
    }

}

if (!function_exists('grava_data_hora')) {

    function grava_data_hora($data) {
        if (!empty($data)) {
            $novaData = substr($data, 6, 4) . '-' . substr($data, 3, 2) . '-' . substr($data, 0, 2) . substr($data, 10, strlen($data) - 1);
            return $novaData;
        }
    }

}

if (!function_exists('grava_valor')) {

    function grava_valor($valor) {
        return str_replace(",", ".", str_replace(".", "", $valor));
    }

}

if (!function_exists('mostra_valor')) {

    function mostra_valor($valor) {
        return number_format($valor, 2, ",", "");
    }

}

if (!function_exists('e_cnpj')) {
    function e_cnpj($cnpj) {
        if (preg_match('/[0-9]{2}\.?[0-9]{3}\.?[0-9]{3}\/?[0-9]{4}\-?[0-9]{2}/', $cnpj)) {
            return true;
        }
        return false;
    }
}

if (!function_exists('e_cpf')) {
    function e_cpf($cpf) {
        if (preg_match('/[0-9]{3}\.?[0-9]{3}\.?[0-9]{3}\-?[0-9]{2}/', $cpf)) {
            return true;
        }
        return false;
    }
}


if (!function_exists('diff_data')) {

    function diff_data($data_inicial, $data_final) {

        $data_inicial = substr($data_inicial, 0, 10);
        $data_final = substr($data_final, 0, 10);
        // Usa a função strtotime() e pega o timestamp das duas datas:
        //echo $data_inicial."==".$data_final."<Br/>";

        $time_inicial = strtotime($data_inicial);
        $time_final = strtotime($data_final);

        if ($time_inicial < $time_final) {
            // Calcula a diferença de segundos entre as duas datas:
            $diferenca = $time_final - $time_inicial; // 19522800 segundos
            // Calcula a diferença de dias
            $dias = (int) floor($diferenca / (60 * 60 * 24)); // 225 dias
            return $dias;
        }

        return 0;
    }

}
?>